#!/bin/sh

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

# check for /etc/enigma2 folder
if [ ! -d /etc/enigma2 ] ; then
	mkdir -p /etc/enigma2
fi

# check for update-ca-certificates
if [ -f /usr/sbin/update-ca-certificates ] ; then
	update-ca-certificates
fi

# workaround for old libssl
if [ -h /usr/lib/libssl.so.0.9.8 ]; then
	echo "Found symlink /usr/lib/libssl.so.0.9.8"
else
	ln -s /usr/lib/libssl.so.1.0.0 /usr/lib/libssl.so.0.9.8
fi

# workaround for old libcrypto
if [ -h /usr/lib/libcrypto.so.0.9.8 ]; then
	echo "Found symlink /usr/lib/libcrypto.so.0.9.8"
else
	ln -s /usr/lib/libcrypto.so.1.0.0 /usr/lib/libcrypto.so.0.9.8
fi

# workaround for corrupt ssl files
if [ ! "$(grep config.misc.firstrun /etc/enigma2/settings)" == "config.misc.firstrun=false" ]; then
	rm -rf /etc/enigma2/cert.pem &
	rm -rf /etc/enigma2/key.pem &
fi

if [ -d /home/root ]; then
	export HOME=/home/root
	cd
fi

# any debuglevel passed?
DEBUG_LVL=${ENIGMA_DEBUG_LVL:-4}

# LC_ALL available?
if [ -z $LC_ALL ]; then
	export LC_ALL=en_GB.utf8
fi

# init script for sysctl is missing, so manually load /etc/sysctl.conf here
sysctl -p

#(sleep 2; echo "enigma2 is the main pvr application... adjust oom score!"; PID=$(pidof enigma2); \
#        [ -e /proc/$PID/oom_score_adj ] && echo "-999" > /proc/$PID/oom_score_adj || echo "-17" > /proc/$PID/oom_adj;) &

#check for sundtek tuner helper lib
if [ -e /opt/lib/libmediaclient.so ]; then
	LIBS="/opt/lib/libmediaclient.so /usr/lib/libopen.so.0.0.0"
else
	LIBS="/usr/lib/libopen.so.0.0.0"
fi

stbcheck=`cat /proc/stb/info/boxtype`
# enigma main loop
while : ; do
	# set TASKSETVALUE to start enigma2
	if [ -f /proc/stb/info/chipset ]; then
	  BOXCHIPSET=$(head /proc/stb/info/chipset)
	else
	  BOXCHIPSET='unknown'
	fi

	case "$BOXCHIPSET" in
	bcm7356|bcm7362|bcm73625|bcm7252s|bcm72604 )
	  TASKSETVALUE=2;;
	* )
	  TASKSETVALUE=1;;
	esac

	if [ $stbcheck == "gbmv200" ]; then
		count=`ps -ef |grep libreader |grep -v "grep" |wc -l`
		if [ 0 == $count ];then
			libreader 720P_50
		fi
	fi

	# show bootlogo on enigma2 start
	if [ -x /usr/bin/showiframe ]; then
		if [ -f /etc/enigma2/backdrop.mvi ]; then
			/usr/bin/showiframe /etc/enigma2/backdrop.mvi
		elif [ -f /etc/enigma2/bootlogo.mvi ]; then
			/usr/bin/showiframe /etc/enigma2/bootlogo.mvi
		elif [ -f /usr/share/bootlogo.mvi ]; then
			/usr/bin/showiframe /usr/share/bootlogo.mvi
		fi
	fi

	# hook to execute scripts always before enigma2 start
	if [ -x /usr/bin/enigma2_pre_start.sh ]; then
		/usr/bin/enigma2_pre_start.sh
	fi

	# start enigma
	sync
	if [ "$(grep config.crash.enabledebug /etc/enigma2/settings)" == "config.crash.enabledebug=true" ] || [ `grep "imagetype=DEV" /etc/image-version` ]; then
		RANDOMIZE1970=''
		time=`date +%Y` ;
		if [ "$time" = 1970 ]; then
			RANDOMIZE1970="$(strings /dev/urandom | grep -o '[[:alnum:]]' | head -n 5 | tr -d '\n')"
		fi
		LOGFOLDER="/home/root/logs/"
		if [ "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" != "" -a -d "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" ]; then
			LOGFOLDER=$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')
		fi
		if [ ! -d $LOGFOLDER ] ; then mkdir -p $LOGFOLDER; fi
		LOGFILE=${LOGFOLDER}Enigma2-debug-$(date +%Y%m%d_%H-%M-%S)${RANDOMIZE1970}.log
		ln -sf ${LOGFILE} ${LOGFOLDER}currlog
		LD_PRELOAD=$LIBS ENIGMA_DEBUG_LVL=$DEBUG_LVL /usr/bin/enigma2 2>&1 | tee -a ${LOGFILE}
		ret=${PIPESTATUS[0]}
		ln -sf ${LOGFILE} ${LOGFOLDER}lastlog
	else
		LD_PRELOAD=$LIBS ENIGMA_DEBUG_LVL=$DEBUG_LVL /usr/bin/enigma2
		ret=$?
	fi


	# enigma2 exit codes:
	#
	#  1 - halt
	#  2 - reboot
	#  3 - restart enigma in normal mode
	#  4 - front processor upgrade
	#  5 - install new settings
	#  6 - restart enigma in debug mode
	#  7 - manufacturer reset
	# 16 - tbd
	# 42 - restart for unattended update
	# 43 - restart for autobackup restore
	# 44 -  tbd wol
	#
	# >128 signal

	if [ "$ret" -ne "1" ]; then
		if [ $stbcheck == "gbmv200" ] ; then
			killall -9 libreader; sleep 5
		fi
	fi

	case $ret in
		1)
			/sbin/halt
			;;
		2)
			/sbin/reboot
			;;
		3)
			DEBUG_LVL=${ENIGMA_DEBUG_LVL:-4}
			;;
		4)
			/sbin/rmmod lcd
			/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
			sleep 1;
			/sbin/rmmod fp
			/sbin/modprobe fp
			/sbin/reboot
			;;
		5)
			if ! grep -q config.misc.RestartUI /etc/enigma2/settings; then
				echo "config.misc.RestartUI=true" >>/etc/enigma2/settings
			fi
			;;
		6)
			DEBUG_LVL=4
			;;
		7)
			rm -R /etc/enigma2
			;;
		16)
			if [ -e /dev/block/by-name/bootoptions ]; then
				mkdir -p /tmp/bootoptions
				mount /dev/block/by-name/bootoptions /tmp/bootoptions
				cp -f /tmp/bootoptions/STARTUP_RECOVERY /tmp/bootoptions/STARTUP_ONCE
			elif [ $stbcheck == "gbtrio4kpro" ]; then
				cp -f /boot/STARTUP_RECOVERY /boot/STARTUP_ONCE
			else
				echo "rescue" > /proc/stb/fp/boot_mode
			fi
			[[ -e /etc/enigma2/.deep ]] && rm /etc/enigma2/.deep
			/sbin/reboot
			;;
		42)
			df -P | grep -v "tmpfs " | awk '{print $6}' | tail -n +3 > /tmp/upgrade_mountpoints.txt
			while read line; do
				if [  -f $line/var/lib/opkg/status ]; then
				DESTS=$DESTS" --add-dest "$line":"$line
			fi
			done < /tmp/upgrade_mountpoints.txt
			# bind the console (when available)
			[ -f /sys/class/vtconsole/vtcon1/bind ] && echo 1 > /sys/class/vtconsole/vtcon1/bind
			prevupd=0
			currupd=999
			opkg update 2>&1 | tee /home/root/opkgupgrade.log
			# check if we need to upgrade busybox first
			if [ "$(opkg list-upgradable busybox)" != "" ]; then
				opkg update busybox 2>&1 | tee -a /home/root/opkgupgrade.log
			fi
			# update all other packages
			while [ $currupd -gt 0 -a $currupd -ne $prevupd ]; do
				opkg upgrade $DESTS 2>&1 | tee -a /home/root/opkgupgrade.log
				prevupd=$currupd
				currupd=`opkg list-upgradable | wc -l`
				echo "===> $currupd PACKAGE(S) REMAINING" >> /home/root/opkgupgrade.log
			done
			/sbin/reboot
			;;
		43)
			# restore a full autobackup
			[ -f /sys/class/vtconsole/vtcon1/bind ] && echo 1 > /sys/class/vtconsole/vtcon1/bind
			/etc/init.d/settings-restore.sh
			[ -f /etc/init.d/softcam ] && /etc/init.d/softcam restart
			break
			;;
		44)
			echo "    " > /dev/lcd0
			/usr/bin/gigablue_wol
			;;
		*)
			break
			;;
	esac

done
